/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.WireSpool;
import com.mrh0.createaddition.util.Util;
import java.util.HashMap;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public interface IWireNode {
    public static final int MAX_LENGTH = (Integer)Config.CONNECTOR_MAX_LENGTH.get();

    public class_243 getNodeOffset(int var1);

    default public int getNodeFromPos(class_243 vector3d) {
        return 0;
    }

    default public int getNodeCount() {
        return 1;
    }

    public static boolean hasPos(class_2487 nbt, int node) {
        return nbt.method_10545("x" + node) && nbt.method_10545("y" + node) && nbt.method_10545("z" + node);
    }

    public static boolean hasNode(class_2487 nbt, int node) {
        return IWireNode.hasPos(nbt, node) && nbt.method_10545("type" + node);
    }

    default public int findOpenNode(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    default public class_2487 writeNode(class_2487 nbt, int node) {
        class_2338 pos = this.getNodePos(node);
        if (pos == null) {
            return nbt;
        }
        int index = this.getOtherNodeIndex(node);
        WireType type = this.getNodeType(node);
        if (type == null) {
            return nbt;
        }
        nbt.method_10569("x" + node, pos.method_10263());
        nbt.method_10569("y" + node, pos.method_10264());
        nbt.method_10569("z" + node, pos.method_10260());
        nbt.method_10569("node" + node, index);
        nbt.method_10569("type" + node, type.getIndex());
        return nbt;
    }

    public static class_2338 readNodeBlockPos(class_2487 nbt, int node) {
        return new class_2338(nbt.method_10550("x" + node), nbt.method_10550("y" + node), nbt.method_10550("z" + node));
    }

    public static WireType readNodeWireType(class_2487 nbt, int node) {
        return WireType.fromIndex(nbt.method_10550("type" + node));
    }

    public static int readNodeIndex(class_2487 nbt, int node) {
        return nbt.method_10550("node" + node);
    }

    default public void readNode(class_2487 nbt, int node) {
        if (!IWireNode.hasNode(nbt, node)) {
            return;
        }
        class_2338 pos = IWireNode.readNodeBlockPos(nbt, node);
        WireType type = IWireNode.readNodeWireType(nbt, node);
        int index = IWireNode.readNodeIndex(nbt, node);
        this.setNode(node, index, pos, type);
    }

    public static void clearNode(class_2487 nbt, int node) {
        nbt.method_10569("node" + node, -1);
        nbt.method_10569("type" + node, -1);
    }

    public void setNode(int var1, int var2, class_2338 var3, WireType var4);

    default public void removeNode(int node) {
        this.setNode(node, -1, null, null);
    }

    public class_2338 getNodePos(int var1);

    public WireType getNodeType(int var1);

    public int getOtherNodeIndex(int var1);

    public void invalidateNodeCache();

    default public boolean hasConnection(int node) {
        return this.getNodePos(node) != null;
    }

    default public boolean hasConnectionTo(class_2338 pos1) {
        if (pos1 == null) {
            return false;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            class_2338 pos2 = this.getNodePos(i);
            if (pos2 == null || !pos1.equals((Object)pos2)) continue;
            return true;
        }
        return false;
    }

    public static int findConnectionTo(IWireNode wn, class_2338 pos) {
        if (pos == null) {
            return -1;
        }
        for (int i = 0; i < wn.getNodeCount(); ++i) {
            class_2338 pos2 = wn.getNodePos(i);
            if (pos2 == null || !pos.equals((Object)pos2)) continue;
            return i;
        }
        return -1;
    }

    public class_2338 getMyPos();

    public IWireNode getNode(int var1);

    public static WireConnectResult connect(class_1937 world, class_2338 pos1, int node1, class_2338 pos2, int node2, WireType type) {
        class_2586 te1 = world.method_8321(pos1);
        if (te1 == null) {
            return WireConnectResult.INVALID;
        }
        class_2586 te2 = world.method_8321(pos2);
        if (te2 == null) {
            return WireConnectResult.INVALID;
        }
        if (te1 == te2) {
            return WireConnectResult.INVALID;
        }
        if (!(te1 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (!(te2 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (node1 < 0 || node2 < 0) {
            return WireConnectResult.COUNT;
        }
        if (pos1.method_10262((class_2382)pos2) > (double)(MAX_LENGTH * MAX_LENGTH)) {
            return WireConnectResult.LONG;
        }
        IWireNode wn1 = (IWireNode)te1;
        IWireNode wn2 = (IWireNode)te2;
        if (wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.EXISTS;
        }
        wn1.setNode(node1, node2, wn2.getMyPos(), type);
        wn2.setNode(node2, node1, wn1.getMyPos(), type);
        return WireConnectResult.getLink(wn2.isNodeInput(node2), wn2.isNodeOutput(node2));
    }

    public static WireType getTypeOfConnection(class_1937 world, class_2338 pos1, class_2338 pos2) {
        class_2586 te1 = world.method_8321(pos1);
        if (te1 == null) {
            return null;
        }
        if (!(te1 instanceof IWireNode)) {
            return null;
        }
        IWireNode wn1 = (IWireNode)te1;
        if (!wn1.hasConnectionTo(pos2)) {
            return null;
        }
        int node1 = IWireNode.findConnectionTo(wn1, pos2);
        return wn1.getNodeType(node1);
    }

    public static WireConnectResult disconnect(class_1937 world, class_2338 pos1, class_2338 pos2) {
        class_2586 te1 = world.method_8321(pos1);
        if (te1 == null) {
            return WireConnectResult.INVALID;
        }
        class_2586 te2 = world.method_8321(pos2);
        if (te2 == null) {
            return WireConnectResult.INVALID;
        }
        if (te1 == te2) {
            return WireConnectResult.INVALID;
        }
        if (!(te1 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (!(te2 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        IWireNode wn1 = (IWireNode)te1;
        IWireNode wn2 = (IWireNode)te2;
        if (!wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.NO_CONNECTION;
        }
        int node1 = IWireNode.findConnectionTo(wn1, pos2);
        int node2 = IWireNode.findConnectionTo(wn2, pos1);
        if (node1 < 0) {
            return WireConnectResult.NO_CONNECTION;
        }
        if (node2 < 0) {
            return WireConnectResult.NO_CONNECTION;
        }
        wn1.removeNode(node1);
        wn2.removeNode(node2);
        return WireConnectResult.REMOVED;
    }

    public static IWireNode getWireNode(class_1937 world, class_2338 pos) {
        if (pos == null) {
            return null;
        }
        class_2586 te = world.method_8321(pos);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IWireNode)) {
            return null;
        }
        return (IWireNode)te;
    }

    default public boolean isNodeInput(int node) {
        return true;
    }

    default public boolean isNodeOutput(int node) {
        return true;
    }

    public static void dropWire(class_1937 world, class_2338 pos, class_1799 stack) {
        class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{stack}));
    }

    default public void dropWires(class_1937 world) {
        class_2371 stacks = class_2371.method_10213((int)WireType.values().length, (Object)class_1799.field_8037);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            int n = this.getNodeType(i).getIndex();
            if (((class_1799)stacks.get(n)).method_7960()) {
                stacks.set(n, (Object)this.getNodeType(i).getDrop());
                continue;
            }
            ((class_1799)stacks.get(n)).method_7933(this.getNodeType(i).getDrop().method_7947());
        }
        for (class_1799 stack : stacks) {
            IWireNode.dropWire(world, this.getMyPos(), stack);
        }
    }

    default public void dropWires(class_1937 world, class_1657 player) {
        class_2371 stacks1 = class_2371.method_10213((int)WireType.values().length, (Object)class_1799.field_8037);
        class_2371 stacks2 = class_2371.method_10213((int)WireType.values().length, (Object)class_1799.field_8037);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            int n = this.getNodeType(i).getIndex();
            class_1799 spools = Util.findStack(((WireSpool)((Object)CAItems.SPOOL.get())).method_8389(), player.method_31548());
            if (spools.method_7947() > 0) {
                if (((class_1799)stacks1.get(n)).method_7960()) {
                    stacks1.set(n, (Object)this.getNodeType(i).getSourceDrop());
                } else {
                    ((class_1799)stacks1.get(n)).method_7933(this.getNodeType(i).getSourceDrop().method_7947());
                }
                spools.method_7934(1);
                continue;
            }
            if (((class_1799)stacks2.get(n)).method_7960()) {
                stacks2.set(n, (Object)this.getNodeType(i).getDrop());
                continue;
            }
            ((class_1799)stacks2.get(n)).method_7933(this.getNodeType(i).getDrop().method_7947());
        }
        for (class_1799 stack : stacks1) {
            if (stack.method_7960()) continue;
            IWireNode.dropWire(world, this.getMyPos(), player.method_31548().method_7394(stack) ? class_1799.field_8037 : stack);
        }
        for (class_1799 stack : stacks2) {
            if (stack.method_7960()) continue;
            IWireNode.dropWire(world, this.getMyPos(), player.method_31548().method_7394(stack) ? class_1799.field_8037 : stack);
        }
    }

    default public boolean isNodeIndicesConnected(int in, int other) {
        return true;
    }

    default public boolean awakeNetwork(class_1937 world) {
        boolean b = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.isNetworkValid(i)) continue;
            this.setNetwork(i, EnergyNetwork.nextNode(world, new EnergyNetwork(world), new HashMap<String, IWireNode>(), this, i));
            b = true;
        }
        return b;
    }

    public EnergyNetwork getNetwork(int var1);

    public void setNetwork(int var1, EnergyNetwork var2);

    default public boolean isNetworkValid(int node) {
        if (this.getNetwork(node) == null) {
            return false;
        }
        return this.getNetwork(node).isValid();
    }

    default public void preformRemoveOfNode(int node) {
        this.removeNode(node);
        this.invalidateNodeCache();
    }
}

